/**
 * @file xmc1_ccu4_map.h
 * @date 2015-08-25
 *
 * @cond
 *********************************************************************************************************************
 * XMClib v2.1.16 - XMC Peripheral Driver Library 
 *
 * Copyright (c) 2015-2017, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the 
 * following conditions are met:   
 *                                                                              
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 * disclaimer.                        
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials provided with the distribution.                       
 * 
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 * products derived from this software without specific prior written permission.                                           
 *                                                                              
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE  
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                  
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with 
 * Infineon Technologies AG dave@infineon.com).                                                          
 *********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-08-25:
 *     - Initial version
 *
 * @endcond
 */

#ifndef XMC1_CCU4_MAP_H
#define XMC1_CCU4_MAP_H

#if UC_SERIES != XMC14
#define XMC_CCU4_SLICE_INPUT_A (0U)
#define XMC_CCU4_SLICE_INPUT_B (1U)
#define XMC_CCU4_SLICE_INPUT_C (2U)
#define XMC_CCU4_SLICE_INPUT_D (3U)
#define XMC_CCU4_SLICE_INPUT_E (4U)
#define XMC_CCU4_SLICE_INPUT_F (5U)
#define XMC_CCU4_SLICE_INPUT_G (6U)
#define XMC_CCU4_SLICE_INPUT_H (7U)
#define XMC_CCU4_SLICE_INPUT_I (8U)
#define XMC_CCU4_SLICE_INPUT_J (9U)
#define XMC_CCU4_SLICE_INPUT_K (10U)
#define XMC_CCU4_SLICE_INPUT_L (11U)
#define XMC_CCU4_SLICE_INPUT_M (12U)
#define XMC_CCU4_SLICE_INPUT_N (13U)
#define XMC_CCU4_SLICE_INPUT_O (14U)
#define XMC_CCU4_SLICE_INPUT_P (15U)
#else
#define XMC_CCU4_SLICE_INPUT_AA (0U)
#define XMC_CCU4_SLICE_INPUT_AB (1U)
#define XMC_CCU4_SLICE_INPUT_AC (2U)
#define XMC_CCU4_SLICE_INPUT_AD (3U)
#define XMC_CCU4_SLICE_INPUT_AE (4U)
#define XMC_CCU4_SLICE_INPUT_AF (5U)
#define XMC_CCU4_SLICE_INPUT_AG (6U)
#define XMC_CCU4_SLICE_INPUT_AH (7U)
#define XMC_CCU4_SLICE_INPUT_AI (8U)
#define XMC_CCU4_SLICE_INPUT_AJ (9U)
#define XMC_CCU4_SLICE_INPUT_AK (10U)
#define XMC_CCU4_SLICE_INPUT_AL (11U)
#define XMC_CCU4_SLICE_INPUT_AM (12U)
#define XMC_CCU4_SLICE_INPUT_AN (13U)
#define XMC_CCU4_SLICE_INPUT_AO (14U)
#define XMC_CCU4_SLICE_INPUT_AP (15U)
#define XMC_CCU4_SLICE_INPUT_AQ (16U)
#define XMC_CCU4_SLICE_INPUT_AR (17U)
#define XMC_CCU4_SLICE_INPUT_AS (18U)
#define XMC_CCU4_SLICE_INPUT_AT (19U)
#define XMC_CCU4_SLICE_INPUT_AU (20U)
#define XMC_CCU4_SLICE_INPUT_AV (21U)
#define XMC_CCU4_SLICE_INPUT_AW (22U)
#define XMC_CCU4_SLICE_INPUT_AX (23U)
#define XMC_CCU4_SLICE_INPUT_AY (24U)
#define XMC_CCU4_SLICE_INPUT_AZ (25U)
#define XMC_CCU4_SLICE_INPUT_BA (26U)
#define XMC_CCU4_SLICE_INPUT_BB (27U)
#define XMC_CCU4_SLICE_INPUT_BC (28U)
#define XMC_CCU4_SLICE_INPUT_BD (29U)
#define XMC_CCU4_SLICE_INPUT_BE (30U)
#define XMC_CCU4_SLICE_INPUT_BF (31U)
#define XMC_CCU4_SLICE_INPUT_BG (32U)
#define XMC_CCU4_SLICE_INPUT_BH (33U)
#define XMC_CCU4_SLICE_INPUT_BI (34U)
#define XMC_CCU4_SLICE_INPUT_BJ (35U)
#define XMC_CCU4_SLICE_INPUT_BK (36U)
#define XMC_CCU4_SLICE_INPUT_BL (37U)
#define XMC_CCU4_SLICE_INPUT_BM (38U)
#define XMC_CCU4_SLICE_INPUT_BN (39U)
#define XMC_CCU4_SLICE_INPUT_BO (40U)
#define XMC_CCU4_SLICE_INPUT_BP (41U)
#define XMC_CCU4_SLICE_INPUT_BQ (42U)
#define XMC_CCU4_SLICE_INPUT_BR (43U)
#define XMC_CCU4_SLICE_INPUT_BS (44U)
#define XMC_CCU4_SLICE_INPUT_BT (45U)
#define XMC_CCU4_SLICE_INPUT_BU (46U)
#define XMC_CCU4_SLICE_INPUT_BV (47U)
#endif

#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == VQFN24)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == VQFN40)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == TSSOP16)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == TSSOP38)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1200) && (UC_PACKAGE == TSSOP38)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_LEDTSledts_SR0           	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_LEDTSledts_SR0           	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == VQFN40)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_LEDTSledts_SR0           	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_LEDTSledts_SR0           	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == TSSOP28)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_LEDTSledts_SR0           	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_LEDTSledts_SR0           	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == TSSOP38)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_LEDTSledts_SR0           	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_LEDTSledts_SR0           	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == VQFN24)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == VQFN40)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == TSSOP16)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == TSSOP28)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == VQFN24)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == VQFN40)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == TSSOP16)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == TSSOP38)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == VQFN24)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == VQFN40)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP16)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP28)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP38)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1401) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_P4_0                     	26
#define CCU40_IN0_P4_8                     	21
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_P4_1                     	26
#define CCU40_IN1_P4_9                     	21
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_LEDTS0_SR                	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_P4_10                    	21
#define CCU40_IN2_P4_2                     	26
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_LEDTS1_SR                	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_P4_11                    	21
#define CCU40_IN3_P4_3                     	26
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_0                     	2
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_P4_8                     	26
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_1                     	2
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_P4_9                     	26
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_10                    	26
#define CCU41_IN2_P4_2                     	2
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_11                    	26
#define CCU41_IN3_P4_3                     	2
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1401) && (UC_PACKAGE == VQFN48)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_P4_0                     	26
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_LEDTS0_SR                	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_LEDTS1_SR                	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_BCCU0_OUT0               	16
#define CCU40_IN0_BCCU0_OUT6               	25
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_P4_0                     	26
#define CCU40_IN0_P4_8                     	21
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ACMP0_OUT            	18
#define CCU40_IN0_SCU_ACMP1_OUT            	17
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_BCCU0_OUT3               	25
#define CCU40_IN1_BCCU0_OUT8               	16
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_P4_1                     	26
#define CCU40_IN1_P4_9                     	21
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ACMP2_OUT            	18
#define CCU40_IN1_SCU_ACMP3_OUT            	17
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_BCCU0_OUT4               	16
#define CCU40_IN2_BCCU0_OUT7               	25
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_P4_10                    	21
#define CCU40_IN2_P4_2                     	26
#define CCU40_IN2_POSIF0_OUT0              	28
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ACMP1_OUT            	18
#define CCU40_IN2_SCU_ACMP2_OUT            	17
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_BCCU0_OUT1               	25
#define CCU40_IN3_BCCU0_OUT5               	16
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_P4_11                    	21
#define CCU40_IN3_P4_3                     	26
#define CCU40_IN3_POSIF0_OUT0              	28
#define CCU40_IN3_POSIF0_OUT1              	29
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ACMP0_OUT            	17
#define CCU40_IN3_SCU_ACMP3_OUT            	18
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_BCCU0_OUT0               	16
#define CCU41_IN0_BCCU0_OUT6               	25
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_CCU81_ST3                	7
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_0                     	2
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_P4_8                     	26
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ACMP0_OUT            	18
#define CCU41_IN0_SCU_ACMP1_OUT            	17
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_BCCU0_OUT1               	16
#define CCU41_IN1_BCCU0_OUT3               	25
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_1                     	2
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_P4_9                     	26
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ACMP2_OUT            	18
#define CCU41_IN1_SCU_ACMP3_OUT            	17
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_BCCU0_OUT2               	16
#define CCU41_IN2_BCCU0_OUT7               	25
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_10                    	26
#define CCU41_IN2_P4_2                     	2
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_POSIF1_OUT0              	28
#define CCU41_IN2_POSIF1_OUT1              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ACMP1_OUT            	18
#define CCU41_IN2_SCU_ACMP2_OUT            	17
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_BCCU0_OUT5               	16
#define CCU41_IN3_BCCU0_OUT8               	25
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_11                    	26
#define CCU41_IN3_P4_3                     	2
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_POSIF1_OUT0              	28
#define CCU41_IN3_POSIF1_OUT1              	29
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ACMP0_OUT            	17
#define CCU41_IN3_SCU_ACMP3_OUT            	18
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN40)
#define CCU40_IN0_BCCU0_OUT0               	16
#define CCU40_IN0_BCCU0_OUT6               	25
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ACMP0_OUT            	18
#define CCU40_IN0_SCU_ACMP1_OUT            	17
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_BCCU0_OUT3               	25
#define CCU40_IN1_BCCU0_OUT8               	16
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ACMP2_OUT            	18
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_BCCU0_OUT4               	16
#define CCU40_IN2_BCCU0_OUT7               	25
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	28
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ACMP1_OUT            	18
#define CCU40_IN2_SCU_ACMP2_OUT            	17
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_BCCU0_OUT1               	25
#define CCU40_IN3_BCCU0_OUT5               	16
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT0              	28
#define CCU40_IN3_POSIF0_OUT1              	29
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ACMP0_OUT            	17
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_BCCU0_OUT0               	16
#define CCU41_IN0_BCCU0_OUT6               	25
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_CCU81_ST3                	7
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_SCU_ACMP0_OUT            	18
#define CCU41_IN0_SCU_ACMP1_OUT            	17
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_BCCU0_OUT1               	16
#define CCU41_IN1_BCCU0_OUT3               	25
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_SCU_ACMP2_OUT            	18
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_BCCU0_OUT2               	16
#define CCU41_IN2_BCCU0_OUT7               	25
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_SCU_ACMP1_OUT            	18
#define CCU41_IN2_SCU_ACMP2_OUT            	17
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_BCCU0_OUT5               	16
#define CCU41_IN3_BCCU0_OUT8               	25
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_SCU_ACMP0_OUT            	17
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN48)
#define CCU40_IN0_BCCU0_OUT0               	16
#define CCU40_IN0_BCCU0_OUT6               	25
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ACMP0_OUT            	18
#define CCU40_IN0_SCU_ACMP1_OUT            	17
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_BCCU0_OUT3               	25
#define CCU40_IN1_BCCU0_OUT8               	16
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ACMP2_OUT            	18
#define CCU40_IN1_SCU_ACMP3_OUT            	17
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_BCCU0_OUT4               	16
#define CCU40_IN2_BCCU0_OUT7               	25
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	28
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ACMP1_OUT            	18
#define CCU40_IN2_SCU_ACMP2_OUT            	17
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_BCCU0_OUT1               	25
#define CCU40_IN3_BCCU0_OUT5               	16
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT0              	28
#define CCU40_IN3_POSIF0_OUT1              	29
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ACMP0_OUT            	17
#define CCU40_IN3_SCU_ACMP3_OUT            	18
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_BCCU0_OUT0               	16
#define CCU41_IN0_BCCU0_OUT6               	25
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_CCU81_ST3                	7
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ACMP0_OUT            	18
#define CCU41_IN0_SCU_ACMP1_OUT            	17
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_BCCU0_OUT1               	16
#define CCU41_IN1_BCCU0_OUT3               	25
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ACMP2_OUT            	18
#define CCU41_IN1_SCU_ACMP3_OUT            	17
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_BCCU0_OUT2               	16
#define CCU41_IN2_BCCU0_OUT7               	25
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_POSIF1_OUT0              	28
#define CCU41_IN2_POSIF1_OUT1              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ACMP1_OUT            	18
#define CCU41_IN2_SCU_ACMP2_OUT            	17
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_BCCU0_OUT5               	16
#define CCU41_IN3_BCCU0_OUT8               	25
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_POSIF1_OUT0              	28
#define CCU41_IN3_POSIF1_OUT1              	29
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ACMP0_OUT            	17
#define CCU41_IN3_SCU_ACMP3_OUT            	18
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN64)
#define CCU40_IN0_BCCU0_OUT0               	16
#define CCU40_IN0_BCCU0_OUT6               	25
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_P4_0                     	26
#define CCU40_IN0_P4_8                     	21
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ACMP0_OUT            	18
#define CCU40_IN0_SCU_ACMP1_OUT            	17
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_BCCU0_OUT3               	25
#define CCU40_IN1_BCCU0_OUT8               	16
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_P4_1                     	26
#define CCU40_IN1_P4_9                     	21
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ACMP2_OUT            	18
#define CCU40_IN1_SCU_ACMP3_OUT            	17
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_BCCU0_OUT4               	16
#define CCU40_IN2_BCCU0_OUT7               	25
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_P4_10                    	21
#define CCU40_IN2_P4_2                     	26
#define CCU40_IN2_POSIF0_OUT0              	28
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ACMP1_OUT            	18
#define CCU40_IN2_SCU_ACMP2_OUT            	17
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_BCCU0_OUT1               	25
#define CCU40_IN3_BCCU0_OUT5               	16
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_P4_11                    	21
#define CCU40_IN3_P4_3                     	26
#define CCU40_IN3_POSIF0_OUT0              	28
#define CCU40_IN3_POSIF0_OUT1              	29
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ACMP0_OUT            	17
#define CCU40_IN3_SCU_ACMP3_OUT            	18
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_BCCU0_OUT0               	16
#define CCU41_IN0_BCCU0_OUT6               	25
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_CCU81_ST3                	7
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_0                     	2
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_P4_8                     	26
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ACMP0_OUT            	18
#define CCU41_IN0_SCU_ACMP1_OUT            	17
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_BCCU0_OUT1               	16
#define CCU41_IN1_BCCU0_OUT3               	25
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_1                     	2
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_P4_9                     	26
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ACMP2_OUT            	18
#define CCU41_IN1_SCU_ACMP3_OUT            	17
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_BCCU0_OUT2               	16
#define CCU41_IN2_BCCU0_OUT7               	25
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_10                    	26
#define CCU41_IN2_P4_2                     	2
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_POSIF1_OUT0              	28
#define CCU41_IN2_POSIF1_OUT1              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ACMP1_OUT            	18
#define CCU41_IN2_SCU_ACMP2_OUT            	17
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_BCCU0_OUT5               	16
#define CCU41_IN3_BCCU0_OUT8               	25
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_11                    	26
#define CCU41_IN3_P4_3                     	2
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_POSIF1_OUT0              	28
#define CCU41_IN3_POSIF1_OUT1              	29
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ACMP0_OUT            	17
#define CCU41_IN3_SCU_ACMP3_OUT            	18
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == TSSOP38)
#define CCU40_IN0_BCCU0_OUT0               	16
#define CCU40_IN0_BCCU0_OUT6               	25
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ACMP0_OUT            	18
#define CCU40_IN0_SCU_ACMP1_OUT            	17
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_BCCU0_OUT3               	25
#define CCU40_IN1_BCCU0_OUT8               	16
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ACMP2_OUT            	18
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_BCCU0_OUT4               	16
#define CCU40_IN2_BCCU0_OUT7               	25
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	28
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ACMP1_OUT            	18
#define CCU40_IN2_SCU_ACMP2_OUT            	17
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_BCCU0_OUT1               	25
#define CCU40_IN3_BCCU0_OUT5               	16
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT0              	28
#define CCU40_IN3_POSIF0_OUT1              	29
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ACMP0_OUT            	17
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_BCCU0_OUT0               	16
#define CCU41_IN0_BCCU0_OUT6               	25
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_CCU81_ST3                	7
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_SCU_ACMP0_OUT            	18
#define CCU41_IN0_SCU_ACMP1_OUT            	17
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_BCCU0_OUT1               	16
#define CCU41_IN1_BCCU0_OUT3               	25
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_SCU_ACMP2_OUT            	18
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_BCCU0_OUT2               	16
#define CCU41_IN2_BCCU0_OUT7               	25
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_SCU_ACMP1_OUT            	18
#define CCU41_IN2_SCU_ACMP2_OUT            	17
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_BCCU0_OUT5               	16
#define CCU41_IN3_BCCU0_OUT8               	25
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_SCU_ACMP0_OUT            	17
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN40)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN48)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_P4_0                     	26
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN64)
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_P4_0                     	26
#define CCU40_IN0_P4_8                     	21
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_P4_1                     	26
#define CCU40_IN1_P4_9                     	21
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_P4_10                    	21
#define CCU40_IN2_P4_2                     	26
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_P4_11                    	21
#define CCU40_IN3_P4_3                     	26
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_0                     	2
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_P4_8                     	26
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_1                     	2
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_P4_9                     	26
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_10                    	26
#define CCU41_IN2_P4_2                     	2
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_11                    	26
#define CCU41_IN3_P4_3                     	2
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == LQFP64)
#define CCU40_IN0_BCCU0_OUT0               	16
#define CCU40_IN0_BCCU0_OUT6               	25
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_P4_0                     	26
#define CCU40_IN0_P4_8                     	21
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ACMP0_OUT            	18
#define CCU40_IN0_SCU_ACMP1_OUT            	17
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_BCCU0_OUT3               	25
#define CCU40_IN1_BCCU0_OUT8               	16
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_P4_1                     	26
#define CCU40_IN1_P4_9                     	21
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ACMP2_OUT            	18
#define CCU40_IN1_SCU_ACMP3_OUT            	17
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_BCCU0_OUT4               	16
#define CCU40_IN2_BCCU0_OUT7               	25
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_LEDTS0_SR                	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_P4_10                    	21
#define CCU40_IN2_P4_2                     	26
#define CCU40_IN2_POSIF0_OUT0              	28
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ACMP1_OUT            	18
#define CCU40_IN2_SCU_ACMP2_OUT            	17
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_BCCU0_OUT1               	25
#define CCU40_IN3_BCCU0_OUT5               	16
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_LEDTS1_SR                	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_P4_11                    	21
#define CCU40_IN3_P4_3                     	26
#define CCU40_IN3_POSIF0_OUT0              	28
#define CCU40_IN3_POSIF0_OUT1              	29
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ACMP0_OUT            	17
#define CCU40_IN3_SCU_ACMP3_OUT            	18
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_BCCU0_OUT0               	16
#define CCU41_IN0_BCCU0_OUT6               	25
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_CCU81_ST3                	7
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_0                     	2
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_P4_8                     	26
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ACMP0_OUT            	18
#define CCU41_IN0_SCU_ACMP1_OUT            	17
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_BCCU0_OUT1               	16
#define CCU41_IN1_BCCU0_OUT3               	25
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_1                     	2
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_P4_9                     	26
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ACMP2_OUT            	18
#define CCU41_IN1_SCU_ACMP3_OUT            	17
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_BCCU0_OUT2               	16
#define CCU41_IN2_BCCU0_OUT7               	25
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_10                    	26
#define CCU41_IN2_P4_2                     	2
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_POSIF1_OUT0              	28
#define CCU41_IN2_POSIF1_OUT1              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ACMP1_OUT            	18
#define CCU41_IN2_SCU_ACMP2_OUT            	17
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_BCCU0_OUT5               	16
#define CCU41_IN3_BCCU0_OUT8               	25
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_11                    	26
#define CCU41_IN3_P4_3                     	2
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_POSIF1_OUT0              	28
#define CCU41_IN3_POSIF1_OUT1              	29
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ACMP0_OUT            	17
#define CCU41_IN3_SCU_ACMP3_OUT            	18
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == VQFN48)
#define CCU40_IN0_BCCU0_OUT0               	16
#define CCU40_IN0_BCCU0_OUT6               	25
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ACMP0_OUT            	18
#define CCU40_IN0_SCU_ACMP1_OUT            	17
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_BCCU0_OUT3               	25
#define CCU40_IN1_BCCU0_OUT8               	16
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ACMP2_OUT            	18
#define CCU40_IN1_SCU_ACMP3_OUT            	17
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_BCCU0_OUT4               	16
#define CCU40_IN2_BCCU0_OUT7               	25
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_LEDTS0_SR                	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_POSIF0_OUT0              	28
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ACMP1_OUT            	18
#define CCU40_IN2_SCU_ACMP2_OUT            	17
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_BCCU0_OUT1               	25
#define CCU40_IN3_BCCU0_OUT5               	16
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_LEDTS1_SR                	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_POSIF0_OUT0              	28
#define CCU40_IN3_POSIF0_OUT1              	29
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ACMP0_OUT            	17
#define CCU40_IN3_SCU_ACMP3_OUT            	18
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_BCCU0_OUT0               	16
#define CCU41_IN0_BCCU0_OUT6               	25
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_CCU81_ST3                	7
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ACMP0_OUT            	18
#define CCU41_IN0_SCU_ACMP1_OUT            	17
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_BCCU0_OUT1               	16
#define CCU41_IN1_BCCU0_OUT3               	25
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ACMP2_OUT            	18
#define CCU41_IN1_SCU_ACMP3_OUT            	17
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_BCCU0_OUT2               	16
#define CCU41_IN2_BCCU0_OUT7               	25
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_POSIF1_OUT0              	28
#define CCU41_IN2_POSIF1_OUT1              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ACMP1_OUT            	18
#define CCU41_IN2_SCU_ACMP2_OUT            	17
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_BCCU0_OUT5               	16
#define CCU41_IN3_BCCU0_OUT8               	25
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_POSIF1_OUT0              	28
#define CCU41_IN3_POSIF1_OUT1              	29
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ACMP0_OUT            	17
#define CCU41_IN3_SCU_ACMP3_OUT            	18
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == VQFN64)
#define CCU40_IN0_BCCU0_OUT0               	16
#define CCU40_IN0_BCCU0_OUT6               	25
#define CCU40_IN0_CCU40_GP01               	12
#define CCU40_IN0_CCU40_SR0                	27
#define CCU40_IN0_CCU40_SR2                	19
#define CCU40_IN0_CCU40_ST0                	20
#define CCU40_IN0_CCU40_ST1                	13
#define CCU40_IN0_CCU40_ST2                	14
#define CCU40_IN0_CCU40_ST3                	15
#define CCU40_IN0_CCU80_ST3                	7
#define CCU40_IN0_ERU0_IOUT0               	10
#define CCU40_IN0_ERU0_PDOUT0              	9
#define CCU40_IN0_ERU0_PDOUT1              	3
#define CCU40_IN0_ERU1_IOUT0               	23
#define CCU40_IN0_ERU1_PDOUT0              	22
#define CCU40_IN0_ERU1_PDOUT1              	24
#define CCU40_IN0_P0_0                     	2
#define CCU40_IN0_P0_12                    	0
#define CCU40_IN0_P0_6                     	1
#define CCU40_IN0_P4_0                     	26
#define CCU40_IN0_P4_8                     	21
#define CCU40_IN0_POSIF0_OUT0              	4
#define CCU40_IN0_POSIF0_OUT1              	5
#define CCU40_IN0_POSIF0_OUT3              	6
#define CCU40_IN0_SCU_ACMP0_OUT            	18
#define CCU40_IN0_SCU_ACMP1_OUT            	17
#define CCU40_IN0_SCU_GSC40                	8
#define CCU40_IN0_U0C0_DX2INS              	11
#define CCU40_IN1_BCCU0_OUT3               	25
#define CCU40_IN1_BCCU0_OUT8               	16
#define CCU40_IN1_CCU40_GP02               	12
#define CCU40_IN1_CCU40_SR1                	27
#define CCU40_IN1_CCU40_SR2                	19
#define CCU40_IN1_CCU40_ST0                	13
#define CCU40_IN1_CCU40_ST1                	20
#define CCU40_IN1_CCU40_ST2                	14
#define CCU40_IN1_CCU40_ST3                	15
#define CCU40_IN1_ERU0_IOUT1               	10
#define CCU40_IN1_ERU0_PDOUT0              	3
#define CCU40_IN1_ERU0_PDOUT1              	9
#define CCU40_IN1_ERU1_IOUT1               	23
#define CCU40_IN1_ERU1_PDOUT0              	24
#define CCU40_IN1_ERU1_PDOUT1              	22
#define CCU40_IN1_P0_1                     	2
#define CCU40_IN1_P0_12                    	0
#define CCU40_IN1_P0_7                     	1
#define CCU40_IN1_P4_1                     	26
#define CCU40_IN1_P4_9                     	21
#define CCU40_IN1_POSIF0_OUT0              	4
#define CCU40_IN1_POSIF0_OUT1              	5
#define CCU40_IN1_POSIF0_OUT3              	6
#define CCU40_IN1_POSIF0_OUT4              	7
#define CCU40_IN1_SCU_ACMP2_OUT            	18
#define CCU40_IN1_SCU_ACMP3_OUT            	17
#define CCU40_IN1_SCU_GSC40                	8
#define CCU40_IN1_U0C1_DX2INS              	11
#define CCU40_IN2_BCCU0_OUT4               	16
#define CCU40_IN2_BCCU0_OUT7               	25
#define CCU40_IN2_CCU40_GP03               	12
#define CCU40_IN2_CCU40_SR1                	19
#define CCU40_IN2_CCU40_SR2                	27
#define CCU40_IN2_CCU40_ST0                	13
#define CCU40_IN2_CCU40_ST1                	14
#define CCU40_IN2_CCU40_ST2                	20
#define CCU40_IN2_CCU40_ST3                	15
#define CCU40_IN2_ERU0_IOUT2               	10
#define CCU40_IN2_ERU0_PDOUT2              	9
#define CCU40_IN2_ERU0_PDOUT3              	3
#define CCU40_IN2_ERU1_IOUT2               	23
#define CCU40_IN2_ERU1_PDOUT2              	22
#define CCU40_IN2_ERU1_PDOUT3              	24
#define CCU40_IN2_LEDTS0_SR                	11
#define CCU40_IN2_P0_12                    	0
#define CCU40_IN2_P0_2                     	2
#define CCU40_IN2_P0_8                     	1
#define CCU40_IN2_P4_10                    	21
#define CCU40_IN2_P4_2                     	26
#define CCU40_IN2_POSIF0_OUT0              	28
#define CCU40_IN2_POSIF0_OUT1              	4
#define CCU40_IN2_POSIF0_OUT2              	5
#define CCU40_IN2_POSIF0_OUT3              	6
#define CCU40_IN2_POSIF0_OUT4              	7
#define CCU40_IN2_SCU_ACMP1_OUT            	18
#define CCU40_IN2_SCU_ACMP2_OUT            	17
#define CCU40_IN2_SCU_GSC40                	8
#define CCU40_IN3_BCCU0_OUT1               	25
#define CCU40_IN3_BCCU0_OUT5               	16
#define CCU40_IN3_CCU40_GP00               	12
#define CCU40_IN3_CCU40_SR1                	19
#define CCU40_IN3_CCU40_SR3                	27
#define CCU40_IN3_CCU40_ST0                	13
#define CCU40_IN3_CCU40_ST1                	14
#define CCU40_IN3_CCU40_ST2                	15
#define CCU40_IN3_CCU40_ST3                	20
#define CCU40_IN3_CCU80_IGBTO              	7
#define CCU40_IN3_ERU0_IOUT3               	10
#define CCU40_IN3_ERU0_PDOUT2              	3
#define CCU40_IN3_ERU0_PDOUT3              	9
#define CCU40_IN3_ERU1_IOUT3               	23
#define CCU40_IN3_ERU1_PDOUT2              	24
#define CCU40_IN3_ERU1_PDOUT3              	22
#define CCU40_IN3_LEDTS1_SR                	11
#define CCU40_IN3_P0_12                    	0
#define CCU40_IN3_P0_3                     	2
#define CCU40_IN3_P0_9                     	1
#define CCU40_IN3_P4_11                    	21
#define CCU40_IN3_P4_3                     	26
#define CCU40_IN3_POSIF0_OUT0              	28
#define CCU40_IN3_POSIF0_OUT1              	29
#define CCU40_IN3_POSIF0_OUT3              	4
#define CCU40_IN3_POSIF0_OUT5              	5
#define CCU40_IN3_SCU_ACMP0_OUT            	17
#define CCU40_IN3_SCU_ACMP3_OUT            	18
#define CCU40_IN3_SCU_GSC40                	8
#define CCU40_IN3_VADC0_G0ARBCNT           	6
#define CCU41_IN0_BCCU0_OUT0               	16
#define CCU41_IN0_BCCU0_OUT6               	25
#define CCU41_IN0_CCU41_GP01               	12
#define CCU41_IN0_CCU41_SR0                	27
#define CCU41_IN0_CCU41_SR2                	19
#define CCU41_IN0_CCU41_ST0                	20
#define CCU41_IN0_CCU41_ST1                	13
#define CCU41_IN0_CCU41_ST2                	14
#define CCU41_IN0_CCU41_ST3                	15
#define CCU41_IN0_CCU81_ST3                	7
#define CCU41_IN0_ERU0_IOUT0               	10
#define CCU41_IN0_ERU0_PDOUT0              	9
#define CCU41_IN0_ERU0_PDOUT1              	3
#define CCU41_IN0_ERU1_IOUT0               	23
#define CCU41_IN0_ERU1_PDOUT0              	22
#define CCU41_IN0_ERU1_PDOUT1              	24
#define CCU41_IN0_P0_4                     	1
#define CCU41_IN0_P3_0                     	0
#define CCU41_IN0_P4_0                     	2
#define CCU41_IN0_P4_4                     	21
#define CCU41_IN0_P4_8                     	26
#define CCU41_IN0_POSIF1_OUT0              	4
#define CCU41_IN0_POSIF1_OUT1              	5
#define CCU41_IN0_POSIF1_OUT3              	6
#define CCU41_IN0_SCU_ACMP0_OUT            	18
#define CCU41_IN0_SCU_ACMP1_OUT            	17
#define CCU41_IN0_SCU_GSC40                	8
#define CCU41_IN0_U1C0_DX2INS              	28
#define CCU41_IN1_BCCU0_OUT1               	16
#define CCU41_IN1_BCCU0_OUT3               	25
#define CCU41_IN1_CCU40_ST1                	11
#define CCU41_IN1_CCU41_GP02               	12
#define CCU41_IN1_CCU41_SR1                	27
#define CCU41_IN1_CCU41_SR2                	19
#define CCU41_IN1_CCU41_ST0                	13
#define CCU41_IN1_CCU41_ST1                	20
#define CCU41_IN1_CCU41_ST2                	14
#define CCU41_IN1_CCU41_ST3                	15
#define CCU41_IN1_ERU0_IOUT1               	10
#define CCU41_IN1_ERU0_PDOUT0              	3
#define CCU41_IN1_ERU0_PDOUT1              	9
#define CCU41_IN1_ERU1_IOUT1               	23
#define CCU41_IN1_ERU1_PDOUT0              	24
#define CCU41_IN1_ERU1_PDOUT1              	22
#define CCU41_IN1_P0_5                     	1
#define CCU41_IN1_P3_0                     	0
#define CCU41_IN1_P4_1                     	2
#define CCU41_IN1_P4_5                     	21
#define CCU41_IN1_P4_9                     	26
#define CCU41_IN1_POSIF1_OUT0              	4
#define CCU41_IN1_POSIF1_OUT1              	5
#define CCU41_IN1_POSIF1_OUT3              	6
#define CCU41_IN1_POSIF1_OUT4              	7
#define CCU41_IN1_SCU_ACMP2_OUT            	18
#define CCU41_IN1_SCU_ACMP3_OUT            	17
#define CCU41_IN1_SCU_GSC40                	8
#define CCU41_IN1_U1C1_DX2INS              	28
#define CCU41_IN2_BCCU0_OUT2               	16
#define CCU41_IN2_BCCU0_OUT7               	25
#define CCU41_IN2_CCU40_ST2                	11
#define CCU41_IN2_CCU41_GP03               	12
#define CCU41_IN2_CCU41_SR1                	19
#define CCU41_IN2_CCU41_SR2                	27
#define CCU41_IN2_CCU41_ST0                	13
#define CCU41_IN2_CCU41_ST1                	14
#define CCU41_IN2_CCU41_ST2                	20
#define CCU41_IN2_CCU41_ST3                	15
#define CCU41_IN2_ERU0_IOUT2               	10
#define CCU41_IN2_ERU0_PDOUT2              	9
#define CCU41_IN2_ERU0_PDOUT3              	3
#define CCU41_IN2_ERU1_IOUT2               	23
#define CCU41_IN2_ERU1_PDOUT2              	22
#define CCU41_IN2_ERU1_PDOUT3              	24
#define CCU41_IN2_P0_6                     	1
#define CCU41_IN2_P3_0                     	0
#define CCU41_IN2_P4_10                    	26
#define CCU41_IN2_P4_2                     	2
#define CCU41_IN2_P4_6                     	21
#define CCU41_IN2_POSIF1_OUT0              	28
#define CCU41_IN2_POSIF1_OUT1              	4
#define CCU41_IN2_POSIF1_OUT2              	5
#define CCU41_IN2_POSIF1_OUT3              	6
#define CCU41_IN2_POSIF1_OUT4              	7
#define CCU41_IN2_SCU_ACMP1_OUT            	18
#define CCU41_IN2_SCU_ACMP2_OUT            	17
#define CCU41_IN2_SCU_GSC40                	8
#define CCU41_IN3_BCCU0_OUT5               	16
#define CCU41_IN3_BCCU0_OUT8               	25
#define CCU41_IN3_CCU40_ST3                	11
#define CCU41_IN3_CCU41_SR1                	19
#define CCU41_IN3_CCU41_SR3                	27
#define CCU41_IN3_CCU41_ST0                	13
#define CCU41_IN3_CCU41_ST1                	14
#define CCU41_IN3_CCU41_ST2                	15
#define CCU41_IN3_CCU41_ST3                	20
#define CCU41_IN3_CCU81_IGBTO              	7
#define CCU41_IN3_ERU0_IOUT3               	10
#define CCU41_IN3_ERU0_PDOUT2              	3
#define CCU41_IN3_ERU0_PDOUT3              	9
#define CCU41_IN3_ERU1_IOUT3               	23
#define CCU41_IN3_ERU1_PDOUT2              	24
#define CCU41_IN3_ERU1_PDOUT3              	22
#define CCU41_IN3_P0_7                     	1
#define CCU41_IN3_P3_0                     	0
#define CCU41_IN3_P4_11                    	26
#define CCU41_IN3_P4_3                     	2
#define CCU41_IN3_P4_7                     	21
#define CCU41_IN3_POSIF1_OUT0              	28
#define CCU41_IN3_POSIF1_OUT1              	29
#define CCU41_IN3_POSIF1_OUT3              	4
#define CCU41_IN3_POSIF1_OUT5              	5
#define CCU41_IN3_SCU_ACMP0_OUT            	17
#define CCU41_IN3_SCU_ACMP3_OUT            	18
#define CCU41_IN3_SCU_GSC40                	8
#define CCU41_IN3_VADC0_G0ARBCNT           	6
#endif

#endif /* XMC1_CCU4_MAP_H */
